// For PPL renderer (r_ppl = 1)

_bump.vsh
{
	include bump.vsh
}

_bump.fsh
{
	uniform sampler2D	u_ColorMap;
	uniform sampler2D	u_NormalMap;
	uniform sampler2D	u_SpecularMap;
	uniform	float		u_Mirror;	// -1.0 for mirrors, else 1.0
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec2		texCoord;
	varying	vec3		Tangent;
	varying	vec3		Binormal;
	varying	vec3		Normal;
	include PackData.inc
	void main(void)
	{
		include clipPlane.inc
		vec4 pix = texture2D(u_ColorMap, texCoord);
		include alpha_test.inc
		vec3 spec = texture2D(u_SpecularMap, texCoord).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n = tangentToWorldMatrix * normalize(texture2D(u_NormalMap, texCoord).xyz - 0.5);
		PackData(pix, n, spec);
	}
}


_bump_interpolate.vsh
{
	include bump_interpolate.vsh
}

_bump_interpolate.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	uniform sampler2D	u_NormalMap0;
	uniform sampler2D	u_NormalMap1;
	uniform sampler2D	u_SpecularMap0;
	uniform sampler2D	u_SpecularMap1;
	uniform	float		u_Mirror;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		texCoords;
	varying	vec3		Tangent;
	varying	vec3		Binormal;
	varying	vec3		Normal;
	varying vec4		color;
	include PackData.inc
	void main(void)
	{
		include clipPlane.inc
		vec3 sample0 = texture2D(u_ColorMap0, texCoords.xy).rgb;
		vec4 sample1 = texture2D(u_ColorMap1, texCoords.zw);
		float alpha = sample1.a * color.a;
		vec3 s0 = texture2D(u_SpecularMap0, texCoords.xy).rgb;
		vec3 s1 = texture2D(u_SpecularMap1, texCoords.zw).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n0 = normalize(texture2D(u_NormalMap0, texCoords.xy).xyz - 0.5);
		vec3 n1 = normalize(texture2D(u_NormalMap1, texCoords.zw).xyz - 0.5);
		vec4 c = vec4(color.rgb * mix(sample0, sample1.rgb, alpha), 1.0);
		vec3 n = tangentToWorldMatrix * normalize(mix(n0, n1, alpha));
		vec3 s = mix(s0, s1, alpha);
		PackData(c, n, s);
	}
}


_bump_interpolate_at.vsh
{
	include bump_interpolate.vsh
}

_bump_interpolate_at.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	uniform sampler2D	u_NormalMap0;
	uniform sampler2D	u_NormalMap1;
	uniform sampler2D	u_SpecularMap0;
	uniform sampler2D	u_SpecularMap1;
	uniform	float		u_Mirror;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		texCoords;
	varying	vec3		Tangent;
	varying	vec3		Binormal;
	varying	vec3		Normal;
	varying vec4		color;
	include PackData.inc
	void main(void)
	{
		include clipPlane.inc
		vec3 sample0 = texture2D(u_ColorMap0, texCoords.xy).rgb;
		vec4 sample1 = texture2D(u_ColorMap1, texCoords.zw);
		float alpha = sample1.a * color.a;
		vec3 s0 = texture2D(u_SpecularMap0, texCoords.xy).rgb;
		vec3 s1 = texture2D(u_SpecularMap1, texCoords.zw).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n0 = normalize(texture2D(u_NormalMap0, texCoords.xy).xyz - 0.5);
		vec3 n1 = normalize(texture2D(u_NormalMap1, texCoords.zw).xyz - 0.5);
		alpha *= step(0.5, alpha);
		vec4 c = vec4(color.rgb * mix(sample0, sample1.rgb, alpha), 1.0);
		vec3 n = tangentToWorldMatrix * normalize(mix(n0, n1, alpha));
		vec3 s = mix(s0, s1, alpha);
		PackData(c, n, s);
	}
}


_bump_parallax.vsh
{
	include parallax.vsh
}


_bump_parallax.fsh
{
	uniform sampler2D	u_ColorMap;
	uniform sampler2D	u_HeightMap;
	uniform sampler2D	u_NormalMap;
	uniform sampler2D	u_SpecularMap;
	uniform	float		u_Mirror;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
	#endif
	varying vec2	texCoord;
	varying	vec3	Tangent;
	varying	vec3	Binormal;
	varying	vec3	Normal;
	varying	vec3	eyeSpaceNormal;
	varying	vec3	eyeSpaceVert;
#ifndef CSM
	varying vec3	eyeVec;
#else
	varying	vec3	eyeSpaceTangent;
	varying	vec3	eyeSpaceBinormal;
	include intersect_cone_exp.inc
#endif
	include PackData.inc
	void main(void)
	{
		vec3 v_clipVertex = eyeSpaceVert;
		include clipPlane.inc

		float a;
		vec3 pt_eye;
#if defined(CSM)
		vec3 T = normalize(eyeSpaceTangent);
		vec3 B = normalize(eyeSpaceBinormal);
#endif
		vec3 N = normalize(eyeSpaceNormal);
		vec3 v = normalize(eyeSpaceVert);

		a = abs(dot(N, v));
		float Scale = sin(clamp(a, 0.0, 1.0) * 1.570796327);

#if defined(CSM)
		vec3 s;
		float df;

		// ray intersect in view direction
		a = Scale * HEIGHT_SCALE / a;
		s = vec3(a*dot(T, v), a*dot(B, v), 1.0);

		df = 0.05 * sqrt(length(fwidth(texCoord)));

		// find the distance to the actualy heightfield
		pt_eye = vec3(texCoord, 0.0);
		intersect_cone_exp (pt_eye, s, df);
#else
		vec3 viewDirNrm = normalize(eyeVec);
		vec2 scale = viewDirNrm.xy * HEIGHT_SCALE / max(viewDirNrm.z * NUM_STEPSf, 0.01);

		pt_eye.xy = texCoord;
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#if NUM_STEPS > 1
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 2
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 3
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 4
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 5
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 6
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 7
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 8
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 9
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 10
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 11
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 12
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 13
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 14
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 15
		pt_eye.xy += scale * (1.0 - vec2(texture2D(u_HeightMap, pt_eye.xy).r * Scale) - 1.0);
#endif

#endif
		// compute the final color
		vec4 pix = texture2D(u_ColorMap, pt_eye.xy);
		include alpha_test.inc
		vec3 spec = texture2D(u_SpecularMap, pt_eye.xy).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n = tangentToWorldMatrix * normalize(texture2D(u_NormalMap, pt_eye.xy).xyz - 0.5);
		PackData(pix, n, spec);
	}
}


_bump_interpolate_parallax.vsh
{
	include parallax_interpolate.vsh
}


_bump_interpolate_parallax.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	uniform sampler2D	u_HeightMap0;
	uniform sampler2D	u_HeightMap1;
	uniform sampler2D	u_NormalMap0;
	uniform sampler2D	u_NormalMap1;
	uniform sampler2D	u_SpecularMap0;
	uniform sampler2D	u_SpecularMap1;
	uniform	float		u_Mirror;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
	#endif
	varying vec2	texCoord;
	varying	vec3	Tangent;
	varying	vec3	Binormal;
	varying	vec3	Normal;
	varying	vec3	eyeSpaceNormal;
	varying	vec3	eyeSpaceVert;
	varying vec4	color;
#ifndef CSM
	varying vec3	eyeVec;
#else
	varying	vec3	eyeSpaceTangent;
	varying	vec3	eyeSpaceBinormal;
	include intersect_cone_exp2.inc
#endif
	include PackData.inc
	void main(void)
	{
		vec3 v_clipVertex = eyeSpaceVert;
		include clipPlane.inc

		float a, alpha;
		vec3 pt_eye0, pt_eye1, sample0, sample1;

		alpha = color.a * texture2D(u_ColorMap0, texCoord).a;
#if defined(CSM)
		vec3 T = normalize(eyeSpaceTangent);
		vec3 B = normalize(eyeSpaceBinormal);
#endif
		vec3 N = normalize(eyeSpaceNormal);
		vec3 v = normalize(eyeSpaceVert);

		a = abs(dot(N, v));
		float Scale = sin(clamp(a, 0.0, 1.0) * 1.570796327);

#if defined(CSM)
		vec3 s;
		float df;

		// ray intersect in view direction
		a = Scale * HEIGHT_SCALE / a;
		s = vec3(a*dot(T, v), a*dot(B, v), 1.0);

		df = 0.05 * sqrt(length(fwidth(texCoord)));

		// find the distance to the actualy heightfield
		pt_eye0 = pt_eye1 = vec3(texCoord, 0.0);
		intersect_cone_exp (pt_eye0, pt_eye1, u_HeightMap0, u_HeightMap1, s, df);
#else
		vec3 viewDirNrm = normalize(eyeVec);
		vec2 scale = viewDirNrm.xy * HEIGHT_SCALE / max(viewDirNrm.z * NUM_STEPSf, 0.01);

		pt_eye0.xy = pt_eye1.xy = texCoord;
	// stage 0:
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#if NUM_STEPS > 1
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 2
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 3
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 4
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 5
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 6
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 7
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 8
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 9
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 10
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 11
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 12
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 13
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 14
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 15
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
	// stage 1:
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#if NUM_STEPS > 1
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 2
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 3
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 4
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 5
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 6
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 7
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 8
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 9
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 10
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 11
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 12
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 13
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 14
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 15
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif

#endif
		// interpolate offsets (alpha is non-parallaxed)
		pt_eye0.xy += alpha * (pt_eye1.xy - pt_eye0.xy);

		// use it to sample texture
		sample0 = texture2D(u_ColorMap0, pt_eye0.xy).rgb;
		sample1 = texture2D(u_ColorMap1, pt_eye0.xy).rgb;
		vec3 s0 = texture2D(u_SpecularMap0, pt_eye0.xy).rgb;
		vec3 s1 = texture2D(u_SpecularMap1, pt_eye0.xy).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n0 = normalize(texture2D(u_NormalMap0, pt_eye0.xy).xyz - 0.5);
		vec3 n1 = normalize(texture2D(u_NormalMap1, pt_eye0.xy).xyz - 0.5);
		vec4 c = vec4(color.rgb * mix(sample0, sample1, alpha), 1.0);
		vec3 n = tangentToWorldMatrix * normalize(mix(n0, n1, alpha));
		vec3 sp = mix(s0, s1, alpha);
		PackData(c, n, sp);
	}
}



_bump_interpolate_parallax_at.vsh
{
	include parallax_interpolate.vsh
}


_bump_interpolate_parallax_at.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	uniform sampler2D	u_HeightMap0;
	uniform sampler2D	u_HeightMap1;
	uniform sampler2D	u_NormalMap0;
	uniform sampler2D	u_NormalMap1;
	uniform sampler2D	u_SpecularMap0;
	uniform sampler2D	u_SpecularMap1;
	uniform	float		u_Mirror;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
	#endif
	varying vec2	texCoord;
	varying	vec3	Tangent;
	varying	vec3	Binormal;
	varying	vec3	Normal;
	varying	vec3	eyeSpaceNormal;
	varying	vec3	eyeSpaceVert;
	varying vec4	color;
#ifndef CSM
	varying vec3	eyeVec;
#else
	varying	vec3	eyeSpaceTangent;
	varying	vec3	eyeSpaceBinormal;
	include intersect_cone_exp2.inc
#endif
	include PackData.inc
	void main(void)
	{
		vec3 v_clipVertex = eyeSpaceVert;
		include clipPlane.inc

		float a, alpha;
		vec3 pt_eye0, pt_eye1, sample0;
		vec4 sample1;

		alpha = color.a * texture2D(u_ColorMap0, texCoord).a;
#if defined(CSM)
		vec3 T = normalize(eyeSpaceTangent);
		vec3 B = normalize(eyeSpaceBinormal);
#endif
		vec3 N = normalize(eyeSpaceNormal);
		vec3 v = normalize(eyeSpaceVert);

		a = abs(dot(N, v));
		float Scale = sin(clamp(a, 0.0, 1.0) * 1.570796327);

#if defined(CSM)
		vec3 s;
		float df;

		// ray intersect in view direction
		a = Scale * HEIGHT_SCALE / a;
		s = vec3(a*dot(T, v), a*dot(B, v), 1.0);

		df = 0.05 * sqrt(length(fwidth(texCoord)));

		// find the distance to the actualy heightfield
		pt_eye0 = pt_eye1 = vec3(texCoord, 0.0);
		intersect_cone_exp (pt_eye0, pt_eye1, u_HeightMap0, u_HeightMap1, s, df);
#else
		vec3 viewDirNrm = normalize(eyeVec);
		vec2 scale = viewDirNrm.xy * HEIGHT_SCALE / max(viewDirNrm.z * NUM_STEPSf, 0.01);

		pt_eye0.xy = pt_eye1.xy = texCoord;
	// stage 0:
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#if NUM_STEPS > 1
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 2
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 3
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 4
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 5
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 6
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 7
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 8
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 9
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 10
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 11
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 12
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 13
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 14
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 15
		pt_eye0.xy += scale * (1.0 - vec2(texture2D(u_HeightMap0, pt_eye0.xy).r * Scale) - 1.0);
#endif
	// stage 1:
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#if NUM_STEPS > 1
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 2
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 3
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 4
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 5
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 6
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 7
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 8
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 9
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 10
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 11
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 12
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 13
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 14
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif
#if NUM_STEPS > 15
		pt_eye1.xy += scale * (1.0 - vec2(texture2D(u_HeightMap1, pt_eye1.xy).r * Scale) - 1.0);
#endif

#endif
		// interpolate offsets (alpha is non-parallaxed)
		pt_eye0.xy += alpha * (pt_eye1.xy - pt_eye0.xy);

		// use it to sample texture
		sample0 = texture2D(u_ColorMap0, pt_eye0.xy).rgb;
		sample1 = texture2D(u_ColorMap1, pt_eye0.xy);

		// interpolate colors
		alpha = sample1.a * color.a;
		vec3 s0 = texture2D(u_SpecularMap0, pt_eye0.xy).rgb;
		vec3 s1 = texture2D(u_SpecularMap1, pt_eye0.xy).rgb;
		mat3 tangentToWorldMatrix = mat3(normalize(Tangent), normalize(Binormal), normalize(Normal) * mix(1.0, -1.0, float(gl_FrontFacing)) * u_Mirror);
		vec3 n0 = normalize(texture2D(u_NormalMap0, pt_eye0.xy).xyz - 0.5);
		vec3 n1 = normalize(texture2D(u_NormalMap1, pt_eye0.xy).xyz - 0.5);
		alpha *= step(0.5, alpha);
		vec4 c = vec4(color.rgb * mix(sample0, sample1.rgb, alpha), 1.0);
		vec3 n = tangentToWorldMatrix * normalize(mix(n0, n1, alpha));
		vec3 sp = mix(s0, s1, alpha);
		PackData(c, n, sp);
	}
}


_DrawLight_OMNI.vsh
{
	void main(void)
	{
		gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	}
}

_DrawLight_OMNI.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_NormalBuffer;
	uniform sampler2DRect	u_SpecularBuffer;
	uniform sampler2DRect	u_DepthBuffer;
#if defined(Stages1)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform vec2		u_AttenuationSizes;
	uniform vec4		u_AttenuationColor;
#endif
#if defined(Stages2)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform ivec2		u_Blend;
	uniform vec2		u_AttenuationSizes[2];
	uniform vec4		u_AttenuationColor[2];
#endif
#if defined(Stages3)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform ivec2		u_Blend[2];
	uniform vec2		u_AttenuationSizes[3];
	uniform vec4		u_AttenuationColor[3];
#endif
#if defined(Stages4)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform sampler2DRect	u_AttenuationMap3;
	uniform ivec2		u_Blend[3];
	uniform vec2		u_AttenuationSizes[4];
	uniform vec4		u_AttenuationColor[4];
#endif
#if defined(Stages5)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform sampler2DRect	u_AttenuationMap3;
	uniform sampler2DRect	u_AttenuationMap4;
	uniform ivec2		u_Blend[4];
	uniform vec2		u_AttenuationSizes[5];
	uniform vec4		u_AttenuationColor[5];
#endif
	uniform vec3		u_LightOrigin;
	uniform vec3		u_ViewOrigin;
	uniform vec3		u_LightColor;
	uniform mat4		u_LightAttenuationMatrix;
	uniform mat4		u_UnprojectMatrix;
	uniform float		u_sphereRadius;
	uniform float		u_noSpecular;
#ifdef RG16F
	include UnPackNormalFloat.inc
#else
	include UnPackNormal.inc
#endif
#ifndef Stages1
	include Blend.inc
#endif
	void main(void)
	{
		float Nz_sign = texture2DRect(u_SpecularBuffer, gl_FragCoord.xy).a;
		if (Nz_sign == 1.0)
		{
			discard;	// no portal surfaces draw
			return;
		}

		// reconstruct vertex position in world space
		float depth = texture2DRect(u_DepthBuffer, gl_FragCoord.xy).r;
		vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
		P.xyz /= P.w;

		// fast culling
		float dist = distance(u_LightOrigin, P.xyz);
		if (dist > u_sphereRadius)
		{
			discard;
			return;
		}

		// compute color attenuation
		vec3 texAtten = (u_LightAttenuationMatrix * vec4(P.xyz, 1.0)).xyz;
		texAtten.z = abs(texAtten.z - 0.5);
		if (texAtten.z >= 0.5)
		{
			discard;
			return;
		}

		vec3 col = 2.0 * (0.5 - texAtten.z) * u_LightColor;

#if defined(Stages1)
		col *= (texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes) * u_AttenuationColor).rgb;
#endif
#if defined(Stages2)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		col *= (Blend(s,d,u_Blend)).rgb;
#endif
#if defined(Stages3)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		col *= (Blend(s,d,u_Blend[1])).rgb;
#endif
#if defined(Stages4)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		s = Blend(s,d,u_Blend[1]);
		d = texture2DRect(u_AttenuationMap3, texAtten.xy * u_AttenuationSizes[3]) * u_AttenuationColor[3];
		col *= (Blend(s,d,u_Blend[2])).rgb;
#endif
#if defined(Stages5)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		s = Blend(s,d,u_Blend[1]);
		d = texture2DRect(u_AttenuationMap3, texAtten.xy * u_AttenuationSizes[3]) * u_AttenuationColor[3];
		s = Blend(s,d,u_Blend[2]);
		d = texture2DRect(u_AttenuationMap4, texAtten.xy * u_AttenuationSizes[4]) * u_AttenuationColor[4];
		col *= (Blend(s,d,u_Blend[3])).rgb;
#endif
		if (dot(col,col) < 0.00001526)	// instead: if (length(col) < 1.0/256.0)
		{
			discard;	// attenuated color is too dark
			return;
		}
#ifdef RG16F
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy).xy);
#else
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy), Nz_sign);
#endif
		// compute light direction in world space
		vec3 L = (u_LightOrigin - P.xyz) / dist;

		float sh = dot(N, L);
		if (sh <= 0.0)		// back face
		{
			discard;
			return;
		}

		// compute view direction in world space
		vec3 V = normalize(u_ViewOrigin - P.xyz);

		col *= sh;
		gl_FragData[0].rgb = col;

		if (u_noSpecular == 0.0)
		{
			// compute half angle in world space
			vec3 H = normalize(L + V);

			gl_FragData[1].rgb = col * pow(dot(N, H), 32.0);
		}
	}
}


_DrawLight_PROJ.vsh
{
	void main(void)
	{
		gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	}
}

_DrawLight_PROJ.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_NormalBuffer;
	uniform sampler2DRect	u_SpecularBuffer;
	uniform sampler2DRect	u_DepthBuffer;
#if defined(Stages1)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform vec2		u_AttenuationSizes;
	uniform vec4		u_AttenuationColor;
#endif
#if defined(Stages2)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform ivec2		u_Blend;
	uniform vec2		u_AttenuationSizes[2];
	uniform vec4		u_AttenuationColor[2];
#endif
#if defined(Stages3)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform ivec2		u_Blend[2];
	uniform vec2		u_AttenuationSizes[3];
	uniform vec4		u_AttenuationColor[3];
#endif
#if defined(Stages4)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform sampler2DRect	u_AttenuationMap3;
	uniform ivec2		u_Blend[3];
	uniform vec2		u_AttenuationSizes[4];
	uniform vec4		u_AttenuationColor[4];
#endif
#if defined(Stages5)
	uniform sampler2DRect	u_AttenuationMap0;
	uniform sampler2DRect	u_AttenuationMap1;
	uniform sampler2DRect	u_AttenuationMap2;
	uniform sampler2DRect	u_AttenuationMap3;
	uniform sampler2DRect	u_AttenuationMap4;
	uniform ivec2		u_Blend[4];
	uniform vec2		u_AttenuationSizes[5];
	uniform vec4		u_AttenuationColor[5];
#endif
	uniform vec3		u_LightOrigin;
	uniform vec3		u_ViewOrigin;
	uniform vec3		u_LightColor;
	uniform mat4		u_LightAttenuationMatrix;
	uniform mat4		u_UnprojectMatrix;
	uniform float		u_sphereRadius;
	uniform float		u_noSpecular;
#ifdef RG16F
	include UnPackNormalFloat.inc
#else
	include UnPackNormal.inc
#endif
#ifndef Stages1
	include Blend.inc
#endif
	void main(void)
	{
		float Nz_sign = texture2DRect(u_SpecularBuffer, gl_FragCoord.xy).a;
		if (Nz_sign == 1.0)
		{
			discard;	// no portal surfaces draw
			return;
		}

		// reconstruct vertex position in world space
		float depth = texture2DRect(u_DepthBuffer, gl_FragCoord.xy).r;
		vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
		P.xyz /= P.w;

		// fast culling
		float dist = distance(u_LightOrigin, P.xyz);
		if (dist > u_sphereRadius)
		{
			discard;
			return;
		}

		// compute color attenuation
		vec4 texAtten = u_LightAttenuationMatrix * vec4(P.xyz, 1.0);
		if(texAtten.w <= 0.0)
		{
			discard;	// fragment is behind the near clip plane
			return;
		}

		vec3 col = (1.0 - texAtten.z) * u_LightColor;
		texAtten.xy /= texAtten.w;

#if defined(Stages1)
		col *= (texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes) * u_AttenuationColor).rgb;
#endif
#if defined(Stages2)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		col *= (Blend(s,d,u_Blend)).rgb;
#endif
#if defined(Stages3)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		col *= (Blend(s,d,u_Blend[1])).rgb;
#endif
#if defined(Stages4)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		s = Blend(s,d,u_Blend[1]);
		d = texture2DRect(u_AttenuationMap3, texAtten.xy * u_AttenuationSizes[3]) * u_AttenuationColor[3];
		col *= (Blend(s,d,u_Blend[2])).rgb;
#endif
#if defined(Stages5)
		vec4 s = texture2DRect(u_AttenuationMap0, texAtten.xy * u_AttenuationSizes[0]) * u_AttenuationColor[0];
		vec4 d = texture2DRect(u_AttenuationMap1, texAtten.xy * u_AttenuationSizes[1]) * u_AttenuationColor[1];
		s = Blend(s,d,u_Blend[0]);
		d = texture2DRect(u_AttenuationMap2, texAtten.xy * u_AttenuationSizes[2]) * u_AttenuationColor[2];
		s = Blend(s,d,u_Blend[1]);
		d = texture2DRect(u_AttenuationMap3, texAtten.xy * u_AttenuationSizes[3]) * u_AttenuationColor[3];
		s = Blend(s,d,u_Blend[2]);
		d = texture2DRect(u_AttenuationMap4, texAtten.xy * u_AttenuationSizes[4]) * u_AttenuationColor[4];
		col *= (Blend(s,d,u_Blend[3])).rgb;
#endif

		if (dot(col,col) < 0.00001526)	// instead: if (length(col) < 1.0/256.0)
		{
			discard;	// attenuated color is too dark
			return;
		}
#ifdef RG16F
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy).xy);
#else
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy), Nz_sign);
#endif
		// compute light direction in world space
		vec3 L = (u_LightOrigin - P.xyz) / dist;

		float sh = dot(N, L);
		if (sh <= 0.0)		// back face
		{
			discard;
			return;
		}

		// compute view direction in world space
		vec3 V = normalize(u_ViewOrigin - P.xyz);

		col *= sh;
		gl_FragData[0].rgb = col;

		if (u_noSpecular == 0.0)
		{
			// compute half angle in world space
			vec3 H = normalize(L + V);

			gl_FragData[1].rgb = col * pow(dot(N, H), 32.0);
		}
	}
}


_sunLight.vsh
{
	void main(void)
	{
		gl_Position = gl_ModelViewProjectionMatrix * gl_Vertex;
	}
}

_sunLight.fsh
{
	#extension GL_ARB_texture_rectangle: enable
	uniform sampler2DRect	u_NormalBuffer;
	uniform sampler2DRect	u_SpecularBuffer;
	uniform sampler2DRect	u_DepthBuffer;
	uniform vec3		u_sunDirection;
	uniform vec3		u_ViewOrigin;
	uniform vec3		u_sunColor;
	uniform mat4		u_UnprojectMatrix;
#ifdef RG16F
	include UnPackNormalFloat.inc
#else
	include UnPackNormal.inc
#endif
	void main(void)
	{
		float Nz_sign = texture2DRect(u_SpecularBuffer, gl_FragCoord.xy).a;
		if (Nz_sign == 1.0)
		{	// no portal surfaces draw
			gl_FragData[0].rgb = vec3(0.0);
			gl_FragData[1].rgb = vec3(0.0);
			return;
		}

		// reconstruct vertex position in world space
		float depth = texture2DRect(u_DepthBuffer, gl_FragCoord.xy).r;
		vec4 P = u_UnprojectMatrix * vec4(gl_FragCoord.xy, depth, 1.0);
		P.xyz /= P.w;
#ifdef RG16F
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy).xy);
#else
		vec3 N = UnPackNormal(texture2DRect(u_NormalBuffer, gl_FragCoord.xy), Nz_sign);
#endif
		float sh = dot(N, u_sunDirection);
		if (sh <= 0.0)
		{	// back face
			gl_FragData[0].rgb = vec3(0.0);
			gl_FragData[1].rgb = vec3(0.0);
			return;
		}

		// compute view direction in world space
		vec3 V = normalize(u_ViewOrigin - P.xyz);

		// compute half angle in world space
		vec3 H = normalize(u_sunDirection + V);

		vec3 col = u_sunColor * sh;
		gl_FragData[0].rgb = col;
		gl_FragData[1].rgb = col * pow(dot(N, H), 32.0);
	}
}
